function m=denormalise(m);
%DENORMALISE denormalises the model M
%    
%    This function denormalises a lazy in order to make fit
%    its limits from [0,1] to the original values, before
%    normalisation.
%    
%    M=DENORMALISE(M) denormalises the model M
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose denormalises the model M.
%	This function denormalises a lazy in order to make fit its limits
%	from [0,1] to the original values, before normalisation.
%
%   @synopsis   m=denormalise(m)
%   @description denormalises the model <CODE>m</CODE>
%
%MAN_PAGE_END  

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 13/09/98 12:02
%
%	All rights reserved


check(m);

n_in = get(m,'n_in');
n_out = get(m,'n_out');

m.mapping = denormalise(m.mapping);

limits = get(m,'limits');

theMinIn = limits(1,1:n_in);
theMinOut = limits(1,n_in+1:n_in+n_out);
theMaxIn = limits(2,1:n_in);
theMaxOut = limits(2,n_in+1:n_in+n_out);


f2 = theMaxOut - theMinOut;
f3 = theMaxIn - theMinIn;

m.examples_x= m.examples_x .* f3(ones(size(m.examples_x,1),1),:) + ...
              theMinIn(ones(size(m.examples_x,1),1),:);
              
m.examples_y= m.examples_y .* f2(ones(size(m.examples_x,1),1),:) + ...
              theMinOut(ones(size(m.examples_x,1),1),:);
