function out=eval(m,varargin)
%EVAL computes the value of the lazy for some input
%    
%    This function returns the output of system as computated
%    by the model, given  a regressor.  
%    
%    OUT=EVAL(M,REGRESSOR) returns the value OUT of the
%    output(s)  of lazy M given the input(s) X.
%    
%    OUT=EVAL(M,REGRESSOR,J) returns the value OUT of the
%    output(s) J of lazy M given the input(s) X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the value of the lazy for some input.  This function
%   returns the output of system as computated by the model, given 
%   a regressor.  
%   
%   @synopsis out=eval(m,regressor)
%   @description  returns the value <code>out</code> of the output(s)  of
%   lazy <code>m</code> given the input(s) <code>x</code>.
%
%   @synopsis out=eval(m,regressor,j)
%   @description  returns the value <code>out</code> of the output(s) <code>j</code> of
%   lazy <code>m</code> given the input(s) <code>x</code>.
%
%MAN_PAGE_END

error(checkargs([{m} varargin],[2 3],'lazy','numeric','numeric'));
check(m);



x = varargin{1};
if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end

%preallocate the matrices
out=zeros(size(x,1),size(j,2));

for i=1:size(j,2)      
  out(:,j(i))= clqLL(m.examples_x,m.examples_y(:,j(i)),x,...
                        m.id_par,m.cmb_par);
end                    
