function d=get(m,label)
%GET gets the value of the attribute of an object
%    
%    D = GET(M,LABEL,OPT) gets the value of the attribute
%    LABEL associated to the object M and return it inside D.
%    The following codes are recognised:
%    
%      NAME: returns the name of the object
%      N_IN: returns the number of inputs of the lazy
%      N_OUT: returns the number of outputs of the lazy
%      USERDATA: returns the 'userData' field
%      OPT: returns the 'opt' field
%      DATE: returns the date of creation of the object
%      LIMITS: returns the limits of the lazy
%      OPTIMPARAMS: returns the indices of the parameters to
%          be optimised
%      NUMPARAMS: returns the number of parameters to be
%          optimised
%      ID_PAR: returns the identification paramenters
%      CMB_PAR: returns the combination paramenters of the
%          models
%      EXAMPLES_X: the database of the input examples
%      EXAMPLES_Y: the database of the output examples
%    
%    See also: SET
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  gets the value of the attribute of an object.
%
%   @synopsis	d = get(m,label,opt)
%   @description gets the value of the attribute <code>label</code>
%   associated to the object <code>m</code> and return it inside <code>d</code>.
%	The following codes are recognised:
%<dl>
%<dt>	name  <dd>	returns the name of the object
%<dt>   n_in  <dd>      	returns the number of inputs of the lazy
%<dt>   n_out  <dd>     	returns the number of outputs of the lazy
%<dt>	userData <dd>		returns the 'userData' field
%<dt>	opt			 <dd>		returns the 'opt' field
%<dt>	date		 <dd>		returns the date of creation of the object
%<dt>	limits	 <dd>				returns the limits of the lazy
%<dt>	 optimparams	 <dd>		returns the indices of the parameters to be optimised
%<dt>	 numparams	 <dd>		returns the number of parameters to be optimised
%<dt>	id_par <dd>   returns the identification paramenters 
%<dt>	cmb_par <dd>	returns the combination paramenters of the models 
%<dt> examples_x      <dd>  the database of the input examples
%<dt> examples_y     <dd>  the database of the output examples
%</dl>
%
%   @see set
%
%MAN_PAGE_END   

error(checkargs({m label},2,'lazy','char'));

switch upper(label),
	
	case 'ID_PAR',
		d=m.id_par;
		
	case 'CMB_PAR',
		d=m.cmb_par;	
		
	case 'EXAMPLES_X',
		d=m.examples_x;
	
	case 'EXAMPLES_Y',
		d=m.examples_y;			
						
	otherwise 
	    d = get(m.mapping,label);
	
end
	
		
