function m = identify(m,in,out,options)
%IDENTIFY Identify the lazy model from data
%    
%    M = IDENTIFY(M,IN,OUT,OPTIONS) performs the
%    identification of the model M using data inside IN and
%    OUT. Define the structure OPTIONS in order to specify the
%    identification method and options.
%    Accepted fields are:
%    
%      ID_PAR: identification parameters
%      CMB_PAR: model combination parameters
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Identify the lazy model from data
%
%   @synopsis	m = identify(m,in,out,options)
%   @description  performs the identification of the model <CODE>m</CODE> using
%	data inside <CODE>in</CODE> and <CODE>out</CODE>. Define the structure
%   <CODE>options</CODE> in order
%	to specify the identification method and options.<br>
%   Accepted fields are:
%<dl>
%<dt>    id_par <dd> identification parameters   
%<dt>    cmb_par <dd> model combination parameters
%</dl>
%
%MAN_PAGE_END

check(m);

if size(in,1) ~= size(out,1),
  error('the number of examples in the input and output database are not the same');
end

%if the system is not inizialized, set the number of inputs and outputs
if get(m,'n_in') == 0 & get(m,'n_out') == 0,
  set(m,'n_in',size(in,2));
  set(m,'n_out',size(out,2));
else
  if size(in,2) ~= get(m,'n_in'),
    error('mismatch between the number of inputs and size of the database of examples');
  elseif size(out,2) ~= get(m,'n_out'),
    error('mismatch between the number of outputs and size of the database of examples');
  end
end

if (nargin>3)
  if ~isstruct(options)
    error('Argument 4 should be a cell array in this calling convention');
  end
else 
  options = struct('dummy_field',0);
end

if isfield(options,'id_par'), 
  if (iscompat(options.id_par, [3,1])) & min(options.id_par,1)>= 0,
    m.id_par=options.id_par;
  elseif (iscompat(options.id_par, [3,2])) & min(options.id_par(:,2)-options.id_par(:,1),1)>= 0,
    m.id_par=options.id_par;
  elseif (iscompat(options.id_par, [3,3])) & min(options.id_par(:,2)-options.id_par(:,1),1)>= 0,
    m.id_par=options.id_par;
  else  
    error('incorrect value or format of the ''id_par'' parameter');
  end
elseif isempty(m.id_par),
  m.id_par=[0;1;0];
end

if isfield(options,'cmb_par'),   
  if (iscompat(options.cmb_par, [1])) & min(options.cmb_par,1)>= 0,
    m.cmb_par=options.cmb_par;
  elseif (iscompat(options.cmb_par, [3,1])) & min(options.cmb_par,1)>= 0,
    m.cmb_par=options.cmb_par;
  else  
    error('incorrect value or format of the ''cmb_par'' parameter');
  end
elseif isempty(m.cmb_par),
  m.cmb_par=1;
end

m.examples_x = in;
m.examples_y = out;

