function m=series(varargin)
%MAN_PAGE_BEGIN
%
%		@purpose	Create a series object
%
%		@synopsis		m=series(m)
%		@description	Trivial call, returns the objectm and repairs
%		it if needed.
%
%		@synopsis		m=series(m1,m2,links)
%		@description	Build a new mapping putting mapping m2 after
%		mapping m1 and linking the inputs using links.
%		Links is a structure with the fields Sy1, Sy2, Sy3, Sm1, Sm2, Sm21 where
%		the Ss are indexes allowing to select a subset of inputs or outputs.
%
%			y = [Sy1(u) ; Sy2(m1(Sm1(u))) ; Sy3(m2([Sm2(u) ; Sm21(m1(Sm1(u)))]))] 
%
%
%        ------------------------------ Sy1 ---------------------------\
%                  +--------------+                                     \
%        ----------|              |-----------------------------------\  \
%   i              |              |     Sy2                            \  \      o
%   n    --- Sm1 --|      m1      |-------------------------------------\------  u
%   p              |              |                                      \  \    t
%   u    ----------|              |---- Sm21\   +----------------+       Perm2-- p
%   t              +--------------+          \ /|                |-- Sy3 ------- u
%   s    -----------------------------------\ X |       m2       |          \    t
%            Sm2                           Perm1|                |   -+      \-- s
%        -----------------------------------/ \ |                |----|
%                                              \|                |   -+
%                                               +----------------+
%
%		In order to get an even more flexible system, permutations perm1 and perm2
%		can be introduced
%
%		@see mapping
%
%MAN_PAGE_END		

if nargin==1,
  if isa(varargin{1},'series') & isa(varargin{1}.mapping ,'mapping'),   %if type series clone it
    m=varargin{1};
  elseif isa(varargin{1},'mapping') & ~ isa(varargin{1},'series'), %if type mapping add the fields
    m.mapping1 = [];
    m.mapping2 = [];
    m.links = [];
     
    f=varargin{1};
    m=class(m,'series',f);
  else                              %if it is something else (usually for update purposes)
    m.mapping1 = [];
    m.mapping2 = [];
    m.links = [];
     
    f=mapping;
    
    arg = struct(varargin{1});
    
    if isfield(arg,'mapping'),
      f=mapping(arg.mapping);
      arg=rmfield(arg,'mapping');
      
      fn=fieldnames(m);
      for i=1:size(fn,1),
	if isfield(arg,fn{i}),
	  m=setfield(m,fn{i},getfield(arg,fn{i}));
	end
      end  
    end
    m=class(m,'series',f);
  end
elseif nargin==2,
	m.mapping1 = varargin{1};
    m.mapping2 = varargin{2};
    f=mapping([varargin{1}.name ' - ' varargin{2}.name],1,1);
    m=class(m,'series',f);
elseif nargin==3,
	m.mapping1 = varargin{1};
    m.mapping2 = varargin{2};
	m.links = varargin{3};
	f=mapping([varargin{1}.name ' - ' varargin{2}.name],...
		max([max(varargin{3}.Sy1) max(varargin{3}.Sm1) max(varargin{3}.Sm2)]),...
		length(varargin{3}.Sy1)+length(varargin{3}.Sy2)+length(varargin{3}.Sy3));
    m=class(m,'series',f);
end
    
