/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#ifndef __INCLUDE_BAGFSC45__
#define __INCLUDE_BAGFSC45__

#include <stdio.h>
#include "definitions.h"
#include "classifier.h"
#include "C45.h"

#ifdef __NO_DATASET__
#define __EVAL_ONLY__
#endif

#ifndef __EVAL_ONLY__
#include "DataSet.h"
#endif

class C45 : public Classifier
{
public:
	Node *head;
    ClassNo MinClass;

	C45(FILE *stream,int nClasses);
	~C45();
	ClassNo eval(double *features, double *confidence);
private:
	char *nextItem(char *line,FILE *stream);
	void load_work(FILE *stream,Node *pNode,
						int nClasses,char *line);
	void load_work2(Node *pNode);
	void delete_work(Node *pNode);

#ifndef __EVAL_ONLY__
public:
	C45::C45(DataSet *D, Boolean *FS, Boolean prune, Boolean useWeight=0);
	void save(FILE *F);
    double errorEstimate();
private:
	void save_work(FILE *F, Node *N, short ind,char *buffer, int l);
#endif
};

class BAGFSC45 : public Classifier
{
  public:
    BAGFSC45(FILE *stream);
	~BAGFSC45();
	ClassNo eval(double *features,double *confidence);
    C45 *firstTree() { return *TreeTable; }
    int B;
  private:
    int nClasses;
    ClassNo MinClass;
    C45 **TreeTable;
    double *vote;

#ifndef __EVAL_ONLY__
  public:
    int K;
    double errorEstimate();
	BAGFSC45();
	BAGFSC45(DataSet *D, int K=0, int B=0);
        // if K==0 then calculation of optimal K is performed
        // if B==0 then calculation of optimal B is performed
	BAGFSC45(BAGFSC45 *t);
	void save(FILE *F);
    static int FindOptimalK(DataSet *AllDatas);

  private:
    void BuildAllTrees(int K, DataSet *D);
	void fillTreeTable(int n, int K, DataSet *D);  
	static void generateFS(Boolean *FS, int MaxAtt, int NumberOfAtt);
#endif
};

#endif


