/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 * *************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <memory.h> 
#include "RRBAGFSC45.h"
#include "DataSet.h"
#include "tools.h"
//#include <crtdbg.h>

int main(int argc, char **argv)
{
	Classifier *c=NULL;
	DataSet *AllItem;

	if ((argc<2)||(argc>4))
	{
		printf("SYNTAX: kc_boostedGenerate <DataSet_file> [<B> [<output_BoostedC45_file>]]\n\n"
			   "The goal of this program is to create a new classifier (a simple vote between\n"
			   "<B> boosted descision trees). If B=0, the default B value (10) will be used.\n"
			   "The program stops for lower value of B if it sees that is not necessary to have\n"
			   "bigger one. If <output_BoostedC45_file> is not specified then the resulting\n"
			   "classifier name will be based on the current date and time.\n");
		exit(255);
	};    
	
    AllItem=new DataSet(argv[1],1);
    printf("\nRead %d cases (%d attributes)\n",AllItem->nItem, AllItem->MaxAtt);

    if (argc>2) c=new BoostedC45(AllItem, atol(argv[2]));
    else c=new BoostedC45(AllItem);

    if (argc==4) c->save(argv[3]);
   	else c->save(); 
    	
	printf("Boosted Trees generation terminated successfully.\n"
	       "The number of Boosted Tree <B> is %i.\n",((BoostedC45*)c)->B);
    
//    c->createAndSaveConfMatrix(AllItem,"confusion_matrixV.txt");

    delete(c);  delete(AllItem);
	// getchar();
	return 0;
};
