/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include "classifier.h"
#include "DataSet.h"

int main(int argc, char **argv)
{
	Classifier *c1,*c2;
	DataSet *AllItem;
	int MaxAtt,r;

	if (argc!=4)
	{
		printf("SYNTAX: kc_comp <DataSet_file> <Classifier_file1> <Classifier_file2>\n\n"
			   "The goal of this program is to test if the two given classifiers have\n"
			   "significativaly different performances.\n"
			   "The examples of the DataSet file can't be used to create the two tested\n"
			   "classifiers. This must be NEW examples.\n");
		exit(255);
	};

	AllItem=new DataSet(argv[1]);
	MaxAtt=AllItem->MaxAtt;
    printf("\nRead %d cases (%d attributes)\n\n",AllItem->nItem, MaxAtt);
	c1=NewClassifier(argv[2]);
    c2=NewClassifier(argv[3]);

    r=c1->Different(c2,AllItem);
    switch (r)
    {
    case 0:
        printf("The performances of the two classifiers are EQUIVALENT.\n"); break;
    case 1:
    case 2:
        printf("The Classifier %i is the best classifier.\n",r); break;
    }
	// printf("press a key.\n"); getchar();
	return 0;
};
