import java.net.*;
import java.io.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

public class Client extends JFrame implements ActionListener, Runnable
{
        static int MMAX(int a,int b) { if (a<b) return b; return a; }

        JTextArea sortie;
	JTextField entree;
	JTextField myName;

        BufferedReader in;
	PrintWriter out;
        JViewport vp;

        public Client(String host, int port)
	{

	        try {
	      		InetAddress addr=InetAddress.getByName(host);
                        Socket s = new Socket(addr, port);
	      		in = new BufferedReader (
				new InputStreamReader (
				  s.getInputStream()));
	      		out = new PrintWriter ( 
				new BufferedWriter (
				   new OutputStreamWriter(
				      s.getOutputStream())),true);
	    	    }
	        catch (IOException e) {	
                    System.out.println("Could not connect to server"); System.exit(255);
                }
                System.out.println("connected to server.");

                setTitle("myIRC v1.0 beta");
                GridBagConstraints c = new GridBagConstraints();
                Container p=getContentPane ();
                p.setLayout (new GridBagLayout ());
                c.fill = GridBagConstraints.BOTH;
                c.weightx=0;
                c.weighty=0;
                c.gridy=0; 
                c.gridx=0; p.add(new JLabel(" Your nickname : "),c);
                c.weightx=1;
                myName=new JTextField();
                c.gridx=1; p.add(myName,c);

                c.gridx=0;
                c.gridwidth=2;
                c.weighty=0;
		entree = new JTextField();
		c.gridy=2; p.add(entree,c);

                final JPanel jp=new JPanel();
                c.weighty=1;
                c.gridy=1; p.add(jp,c);

                sortie = new JTextArea();
		sortie.setEditable(false);

                final JScrollPane jScrollPane2=new JScrollPane();
                jScrollPane2.setViewportView (sortie);
                vp=jScrollPane2.getViewport();
                jScrollPane2.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
                jp.add (jScrollPane2, java.awt.BorderLayout.CENTER);

                addComponentListener(new java.awt.event.ComponentAdapter() {
                    public void componentResized(ComponentEvent e) {
                        jScrollPane2.setPreferredSize(new Dimension(jp.getWidth(),jp.getHeight()-4));
                        jp.revalidate();
                    }
                });

                setIconImage(new javax.swing.ImageIcon (getClass ().getResource ("topIcon.gif")).getImage());
                show();
                setSize(607,363);
                entree.addActionListener(this);	
                
                addWindowListener (new java.awt.event.WindowAdapter () {                
                    public void windowClosing (java.awt.event.WindowEvent evt) {
                        System.exit(0);
                    }
                });
                System.out.println("init finished.");
	}

        public void actionPerformed(final java.awt.event.ActionEvent p1) 
        {
            String nick=myName.getText();
            if (nick.compareTo("")==0)
            {
                JOptionPane.showMessageDialog(this,"enter your nickname first","",JOptionPane.ERROR_MESSAGE);
                return;
            };
            out.println("<"+nick+"> "+entree.getText());
            entree.setText("");
	}

        public void run() 
        {
 	   String str;
	   while (true)
	   {
	      try
	      {
                 sortie.append(in.readLine()+"\n");
                 vp.setViewPosition(new Point(0,MMAX(0,sortie.getLineCount()*16-(int)vp.getExtentSize().getHeight())));
	      }
	      catch (IOException e) 
		{ sortie.setText(e.toString()); };
	   }
        }
	
	public static void main(String args[])
	{
		System.out.println(
			"usage : java Client <host> <port>");
                String host="127.0.0.1";
                int port=7656;
                
		if (args.length>=1)  host=args[0];
		if (args.length>=2) 		
		{
		   try { port= Integer.parseInt(args[1]); }
                   catch (NumberFormatException e) { port=7656; }
 		};
 
                new Thread(new Client(host,port)).start();
	}       
}
