// AudioMute.cpp: implementation of the AudioMute class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "fullscreen.h"
#include "AudioMute.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

AudioMute::AudioMute(CWinApp * app)
{
	m_ItemIndex = 0;
	m_Value = NULL;
	m_theApp = app;

}

AudioMute::~AudioMute()
{
	CloseMixer();
	CloseMixer();

}


//mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm
// Name   : Init
//          
// Descr. : Initializes the mixer control. Most of the work is done in the
//          base class' implementation of Init.
//          Init queries the mixer device for the specified mixer control type.
//          If such a control is found, its current value is queried, and used
//          to initialize the windows control.
//        - If the call to CMixerBase::Init() is succesfull, m_Value is set to
//          the address of the memory allocated by CMixerBase.
//          
// Return : int 0 if failed, 1 otherwise
//
// Arg    : DWORD DstType    : see definition of CMixerBase::Init() for a description
// Arg    : DWORD SrcType    : see definition of CMixerBase::Init() for a description
// Arg    : DWORD ControlType : type of desired switch or selector.
//                              These are valid arguments:
//
//  Selectors   MIXERCONTROL_CONTROLTYPE_SINGLESELECT 
//              MIXERCONTROL_CONTROLTYPE_MUX
//              MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT
//              MIXERCONTROL_CONTROLTYPE_MIXER
//
//
//  Switches    MIXERCONTROL_CONTROLTYPE_BOOLEAN 
//              MIXERCONTROL_CONTROLTYPE_ONOFF
//              MIXERCONTROL_CONTROLTYPE_MUTE
//              MIXERCONTROL_CONTROLTYPE_MONO
//              MIXERCONTROL_CONTROLTYPE_LOUDNESS
//              MIXERCONTROL_CONTROLTYPE_STEREOENH
//
// Arg    : int index : if the mixer control is a Selector (List), specifies the
//                      0-based index of the selector's item to which this object
//                      (and the windows control) will be associated.
//
//-----------------------------------------------------------------------------
int AudioMute::Init( DWORD DstType, DWORD SrcType, DWORD ControlType, int index )
{
	// check the type requested

	if( (ControlType & MIXERCONTROL_CT_CLASS_MASK) != MIXERCONTROL_CT_CLASS_SWITCH )
	{
		if( (ControlType & MIXERCONTROL_CT_CLASS_MASK) != MIXERCONTROL_CT_CLASS_LIST )
		{
            char buf[500];
			sprintf(buf, "AudioMute::Init: Wrong control type: %s", 
					      GetControlTypeString( ControlType ) );
            AfxMessageBox(buf);
			return 0;
		}
		else
			m_ItemIndex = index;
	}
	
	if ( CMixerBase::Init( DstType, SrcType, ControlType, m_theApp->GetMainWnd()->GetSafeHwnd() ) == 0 )
		return 0;

	// check if the 'index' parameter is within the number of items in a multiple
	// items mixer control

	int nItems = 1;
	if( m_Control.fdwControl & MIXERCONTROL_CONTROLF_MULTIPLE )
	{
		nItems = m_Control.cMultipleItems;
		if( index < 0 || index >= nItems )
		{
            char buf[500];
			sprintf(buf, "CMixerNumber::Init: Invalid control index passed: %d", index );
            AfxMessageBox(buf);
			CloseMixer();
			return 0;
		}
	}

	m_Value = (MIXERCONTROLDETAILS_BOOLEAN*)GetValuePtr();

	GetMixerControlValue();
    m_Value_orig = !m_Value[m_ItemIndex].fValue;
	return 1;
}


//mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm
// Name   : OnClicked_
//          
// Descr. : Switches the mixer control off/on
//          
// Return : void
//-----------------------------------------------------------------------------
void AudioMute::OnClicked_() 
{
	if( m_HMixer )
	{
		m_Value[m_ItemIndex].fValue = !m_Value[m_ItemIndex].fValue;
		SetMixerControlValue();
	}
	else
	{
        char buf[500];
        sprintf(buf, "AudioMute::OnClicked: Error: Did you call Init() first?" );
        AfxMessageBox(buf);

	}
}

//mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm
// Name   : OnMixerControlChanged
//          
// Descr. : Message handler called whenever the MCI device sends the MM_MIXM_CONTROL_CHANGE
//          message. The MCI mixer device will send this message for any changing
//          setting, so we need to check that the MCI control that sent the message
//          corresponds to the current selector control.
//          
// Return : LONG
// Arg    : UINT         : 
// Arg    : LONG message : 
//-----------------------------------------------------------------------------
LONG AudioMute::OnMixerControlChanged( UINT, LONG message )
{
	UINT id = ( UINT )message;

	if( id == m_Control.dwControlID ) // query the new value
	{
		if(  ! GetMixerControlValue() )
		{
			AfxMessageBox( "AudioMute::OnMixerControlChanged mixerGetControlDetails failed.\n" );
		}
	}

	return 0L;
}

BOOL AudioMute::GetValue()
{
    GetMixerControlValue();
    return !m_Value[m_ItemIndex].fValue;
}

BOOL AudioMute::SetValue(BOOL value)
{
	if( m_HMixer )
	{
		m_Value[m_ItemIndex].fValue = !value;
		return !SetMixerControlValue();
	}
	else
	{
        char buf[500];
        sprintf(buf, "AudioMute::SetValue: Error: Did you call Init() first?" );
        AfxMessageBox(buf);
        return 1;

	}

}


void AudioMute::RestoreOrigValue()
{
    SetValue(m_Value_orig);
}