// fullscreenView.h : interface of the CFullscreenView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_FULLSCREENVIEW_H__3788993A_C04E_11D7_A53C_0050BAEA00A0__INCLUDED_)
#define AFX_FULLSCREENVIEW_H__3788993A_C04E_11D7_A53C_0050BAEA00A0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <dshow.h>
#include "AudioMute.h"

enum{s640x480,s800x600,s1024x768,fullscreen,custom};

class CFullscreenView : public CView
{
protected: // create from serialization only
	CFullscreenView();
	DECLARE_DYNCREATE(CFullscreenView)

// Attributes
public:
	CFullscreenDoc* GetDocument();

    char* sources;
    int getStrSource();
    bool startVideo(int index=0);
    bool stopVideo();

private:
	IGraphBuilder*	pGraph;// = NULL;
	IMediaControl*	pMediaControl;// = NULL;
	IMediaEvent*	pEvent;
	IVideoWindow*	pVidWin;// = NULL;
	ICaptureGraphBuilder2* pBuilder;
	BOOL m_bBind;
	int m_winHeight;
	int m_winWidth;
    int m_foundSources;
    int m_size;
    int m_x;//upper left corner
    int m_y;//upper left corner
    int m_nRep;
    int m_nRep2;
	int m_index;
	bool m_onTop;
	AudioMute* m_micro;
	AudioMute* m_line;


    // Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFullscreenView)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void OnDraw(CDC* pDC);
	//}}AFX_VIRTUAL

// Implementation
public:
	void SetScreen();
	void SetScreenPosition(int x, int y);
	void SetScreenSize(int x,int y);
	virtual ~CFullscreenView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CFullscreenView)
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnVideoSource1();
	afx_msg void OnVideoSource0();
	afx_msg void OnVideoSource2();
	afx_msg void OnVideoSource3();
	afx_msg void OnVideoSource4();
	afx_msg void OnVideoSource5();
	afx_msg void OnVideoSource6();
	afx_msg void OnVideoSource7();
	afx_msg void OnVideoSource8();
	afx_msg void OnVideoSource9();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void On1024x768();
	afx_msg void On800x600();
	afx_msg void OnFullscreen();
	afx_msg void OnProperties();
	afx_msg void OnFormatproperties();
	afx_msg void On640x480();
	afx_msg void OnUpdate1024x768(CCmdUI* pCmdUI);
	afx_msg void OnUpdate640x480(CCmdUI* pCmdUI);
	afx_msg void OnUpdate800x600(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFullscreen(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource0(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource1(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource2(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource3(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource4(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource5(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource6(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource7(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource8(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVideoSource9(CCmdUI* pCmdUI);
	afx_msg void OnLinein();
	afx_msg void OnMicrophone();
	afx_msg void OnUpdateLinein(CCmdUI* pCmdUI);
	afx_msg void OnUpdateMicrophone(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOther(CCmdUI* pCmdUI);
	afx_msg void OnOther();
	afx_msg void OnTop();
	afx_msg void OnUpdateTop(CCmdUI* pCmdUI);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	void SetRatio();
	void SetSizeType();
	double m_ratio;
	bool m_bMouseDown;
    CPoint m_mouseDownPoint;
    CPoint m_mouseDownPointOrigine;
	bool ChangeToSource(int index);
};

#ifndef _DEBUG  // debug version in fullscreenView.cpp
inline CFullscreenDoc* CFullscreenView::GetDocument()
   { return (CFullscreenDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FULLSCREENVIEW_H__3788993A_C04E_11D7_A53C_0050BAEA00A0__INCLUDED_)
