function [ls,lsbar] = bootstrap(d,n)
%BTSTRAP2 BTSTRAP2 creates n new datasets ready for
%    Bagging purpose or cross validation
%    
%    [LS,LSBAR] = BTSTRAP2(D,N) D is a dataset object, N is
%    the desired number of bootstraps.
%    LS is a cell array containing N new bootstrapped
%    datasets. LSBAR is the complementary cell array for each
%    bootstrap. 
%    
%    See also: CUT, BOOTSTRAP
%    
%    

%MAN_PAGE_BEGIN
%@purpose bootstrap creates n new datasets ready for Bagging purpose or cross validation.
%@synopsis [ls,lsbar] = bootstrap(d,n)
%@description <code>d</code> is a dataset object, <code>n</code> is the desired number of bootstraps.<br>
%<code>ls</code> is a cell array containing <code>n</code> new bootstrapped datasets.
%<code>lsbar</code> is the complementary cell array for each bootstrap. 
%@see cut
%MAN_PAGE_END  
%    

% Copyright (c) 8/04/99
% $ Revision: 1.0 $ 1/08/99 Patrice Latinne
% $ Revision: 1.1 $ 16/05/2000 Antoine Duchateau

loadfromdisk(d)

tref=struct('type','()');
  	
ns = get(d,'ns');
ls=cell(n,1);
lsbar=cell(n,1);

for i=1:n
  btstrap = sort(floor(1+ns*(rand(ns,1))));  
  
  if nargout>1,
	  x = cprsnum(btstrap);
	  lab = 1:ns;
	  for j=1:size(x)
	     z=find(lab~=x(j));     
	     lab=lab(z);
	  end
	  
	  tref.subs = {lab ':'};
      lsbar{i}=subsref(d,tref);
  end
  
  tref.subs = {btstrap ':'};
  ls{i} = subsref(d,tref);
end
