function fs = randfs2(d,prop,nb)
%RANDFS2 RANDFS2 : a features subsets builder by sampling
%    without replacement
%    
%    FS = RANDFS2(D,PROP,NB) 
%    
%    FS   = cell array containing the subsets of features
%    D    = training set build with 'dataset'
%    PROP = percentage of the total number of attributes 
%    NB   = number of subsets
%     fs = randfs1(train,0.5,10);
%    data=get(train,'contdata');
%    d=data(:,fs{1});
%    See also: RANDFS1
%    
%    

%MAN_PAGE_BEGIN
%@purpose RANDFS2 : a features subsets builder by sampling without replacement
%@synopsis FS = RANDFS2(D,PROP,NB)
%@description <br>
%<br>
% <code>FS</code>   = cell array containing the subsets of features<br>
% <code>D</code>    = training set build with 'dataset'<br>
% <code>PROP</code> = percentage of the total number of attributes <br>
% <code>NB</code>   = number of subsets<br>
% @examples  fs = randfs1(train,0.5,10);<br>
%           data=get(train,'contdata');<br>
%           d=data(:,fs{1});<br>
%@see randfs1
%MAN_PAGE_END


rand('state',sum(100*clock));
nv=get(d,'nv')-1;
nv2=ceil(prop*nv);  % fixed number of attributes
fs=cell(nb,1);
 
for i=1:nb
   x=randperm(nv);
   fs{i} = x(1:nv2)';
end