function display(m)
%DISPLAY Display an object of class external
%    
%    DISPLAY(M) Display the object m of class external
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Display an object of class external
%
%   @synopsis	display(m)
%   @description  Display the object m of class external
%
%MAN_PAGE_END

error(checkargs({m},1,'external'));
ps = struct(m.system);

c = struct2cell(ps);
f = fieldnames(ps);

c = [c(1:3);{m.dynamics};c(4:end)];
f = [f(1:3);{'dynamics'};f(4:end)];

ps = cell2struct(c,f,1);

disp(' ');
disp([inputname(1),' =']);
disp(' ');
disp('A external system with the following attributes');
disp(' ');
disp(ps);
disp(' ');
