function errordb(m)
%ERRORDB Graphical User Interface for inspecting the
%    errors of the mappings
%    
%     Lets the user inspect the database of experiments saved
%    inside the model M.
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Graphical User Interface for inspecting the errors of the mappings.
%
%   @synopsys	errordb(m)
%   @description  Lets the user inspect the database of experiments saved inside the model <CODE>m</CODE>.
%
%   @see 
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 5/09/99

f = figure;

title = {'Output' 'Links' 'Mapping Name' 'Data set' 'Type' 'Error'};

opt=get(m,'opt');
if isfield(opt,'errors_database')  & ~isempty(opt.errors_database.system_output),
  database=opt.errors_database;
else
	error(['No error database has been defined for this system. Please use error first.']);
end

for i=1:length(database.system_output),
	title = [title;{mat2str(database.system_output{i}) mat2str(database.output_links{i}) database.mapping_name{i} database.file{i} database.error_type{i} num2str(database.value{i})}]
end

ud = [];
ud.l = columnlist(title,[0 0.07 1 0.87]);
ud.pop1 = uicontrol('style','popupmenu','Units','normal','backgroundcolor',[1 1 1],'string','Output|Mapping name|Data set|Error type|Error','Position',[0.2 0.01 0.3 0.05],'fontname','monaco','callback','sorterrordb');
ud.pop2 = uicontrol('style','popupmenu','Units','normal','backgroundcolor',[1 1 1],'string','Output|Mapping name|Data set|Error type|Error','Position',[0.55 0.01 0.3 0.05],'fontname','monaco','callback','sorterrordb');
s = uicontrol('style','text','Units','normal','string','Sort by:','Position',[0 0.015 0.2 0.04],'fontname','monaco');

ud.switch = (1:length(database.system_output))';
ud.m = m;

set(f,'userdata',ud)
