function [ir, or] = stateregress(m,j)
%STATEREGRESS Compute the regressor for the state mapping
%    
%    [IR, OR] = STATEREGRESS(M,J) does exactly the same as
%    regress for the state mapping
%    
%    See also: REGRESS
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Compute the regressor for the state mapping.
%
%   @synopsis	[ir, or] = stateregress(m,j)
%   @description  does exactly the same as regress for the state mapping
%
%   @see regress
%
%MAN_PAGE_END

if (nargin < 2)|isempty(j),
	j = 1:get(m,'n_state');
end

dd = get(get(m,'data'),'contdata');

listlinks = m.statelinks(j,:);

for i = unique(listlinks(:,1)),
	sub = find(listlinks(:,1) == i);
	
	ir{i} = dd(:,1:m.n_state + get(m,'n_in'));
	or{i} = dd(:,m.n_state + get(m,'n_in')+1:2*m.n_state+get(m,'n_in'));
	or{i} = or{i}(:,listlinks(sub,2));
end
