function check(m); 
%CHECK checks the consistency of all the field of a lazy
%    object
%    
%    This function has been provided in order to make the lazy
%    class more robust since it checks a lazy object for
%    consistency of the data defined in its fields. If a
%    inconsistency is found, an  error message is displayed.
%    
%    CHECK(M) check the consistency of a lazy object.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose checks the consistency of all the field of a lazy object.
%   This function has been provided in order to make the lazy class
%   more robust since it checks a lazy object for consistency of
%   the data defined in its fields. If a inconsistency is found, an 
%   error message is displayed.
%
%   @synopsis check(m)
%   @description  check the consistency of a lazy object.
%
%MAN_PAGE_END

error(checkargs({m},1,'lazy'));

%Check the fields of the mapping superclass
check(m.mapping);

sm=struct(m);

if ~isfield(sm,'id_par'),
	error('object lazy should have a ''id_par'' attribute');
end
if ~isfield(sm,'cmb_par'),
	error('object lazy should have a ''cmb_par'' attribute');
end
if ~isfield(sm,'examples_x'),
	error('object lazy should have a ''examples_x'' attribute');
end

if ~isfield(sm,'examples_y'),
	error('object lazy should have a ''examples_y'' attribute');
end

%now check the dimensions of the examples of the system

if ~isempty(m.examples_x) & ~isempty(m.examples_y),
  if size(m.examples_x,1) ~= size(m.examples_y,1),
    error('the number of examples in the input and output database are not the same');
  end
  
  if size(m.examples_x,2) ~= get(m,'n_in'),
    error('mismatch between the number of inputs and size of the database of examples');
  elseif size(m.examples_y,2) ~= get(m,'n_out'),
    error('mismatch between the number of outputs and size of the database of examples');
  end
end
