function m=normalise(m);
%NORMALISE normalises the model M
%    
%    This function normalizes a lazy in order to make fit its
%    limits to the interval [0,1]
%    
%    M=NORMALISE(M) normalises the model M
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose normalises the model M.
%	This function normalizes a lazy in order to make fit its limits
%	to the interval [0,1]
%
%   @synopsis   m=normalise(m)
%   @description normalises the model <CODE>m</CODE>
%
%MAN_PAGE_END  

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 13/09/98 12:02
%
%	All rights reserved


check(m);

if isempty(m.examples_x) | isempty(m.examples_y)
	error(['Cannot normalise, the model database is empty is empty']);
end

n_in = get(m,'n_in');
n_out = get(m,'n_out');

m.mapping = normalise(m.mapping);

opt = get(m,'opt');
limits = opt.original_limits;

theMinIn = limits(1,1:n_in);
theMinOut = limits(1,n_in+1:n_in+n_out);
theMaxIn = limits(2,1:n_in);
theMaxOut = limits(2,n_in+1:n_in+n_out);

f2 = theMaxOut - theMinOut;
f3 = theMaxIn - theMinIn;

m.examples_x=(m.examples_x- theMinIn(ones(size(m.examples_x,1),1),:)) ...
            ./f3(ones(size(m.examples_x,1),1),:);

m.examples_y=(m.examples_y- theMinOut(ones(size(m.examples_y,1),1),:))...
            ./f2(ones(size(m.examples_y,1),1),:);            


