function check(m); 
%CHECK checks the consistency of all the field of a linear
%    object
%    
%    This function has been provided in order to make the
%    linear class more robust since it checks a linear object
%    for consistency of the data defined in its fields. If a
%    inconsistency is found, an  error message is displayed.
%    
%    CHECK(M) check the consistency of a linear object.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose checks the consistency of all the field of a linear object.
%   This function has been provided in order to make the linear class
%   more robust since it checks a linear object for consistency of
%   the data defined in its fields. If a inconsistency is found, an 
%   error message is displayed.
%
%   @synopsis check(m)
%   @description  check the consistency of a linear object.
%
%MAN_PAGE_END

error(checkargs({m},1,'linear'));

%Check the fields of the mapping superclass
check(m.mapping);

sm=struct(m);

if ~isfield(sm,'linears'),
	error('object linear should have a ''linears'' attribute');
end

% Check the consistency between the linears field and the number of inputs/outputs
if size(m.linears) ~= [get(m,'n_out') get(m,'n_in')+1],
	error(['''centers'' field is not the right size']);
end

