function DOF = dofprod(rls,mfs,x)
% DOFPROD calculates degrees of fulfillment of the rules
% using the product as the fuzzy logic AND operator.
%
% DOF = DOFPROD(RLS,MFS,X)
% Inputs:       RLS - rule matrix
%               MFS - membership function matrix
%               X   - input vector or matrix
%
% Output:       DOF - matrix of degrees of fulfillment
%
% See also TXT2RLS, RLS2TXT, MFSET, MFGET, INFER, DOFMIN, DOFTN.

% Copyright (c) Robert Babuska, 1993-1998

[k,ninps] = size(x);
nrules = size(rls,1);
if isnumeric(mfs), mfs = {mfs}; end;
DOF = mgrade(x(:,1),mfs{1}(rls(:,1),:));
for i = 2 : ninps,
   DOF = DOF.*mgrade(x(:,i),mfs{i}(rls(:,i),:));
end;   
