function out=jacob_inputs(m,varargin)
%JACOB_INPUTS computes the jacobian of the model
%    
%    The procedure for computing the jacobian depends on the
%    underlying representation  of the model. The result OUT
%    is an array of size number of outputs * number of inputs
%    containing the derivatives of the outputs with respect to
%    the inputs.
%    
%    JACOB_INPUTS(M,X) computes for each output the jacobian
%    of the model with respect to the x (the input of the
%    mapping) at point X.
%    
%    JACOB_INPUTS(M,X,J) computes for output J the jacobian of
%    the model with respect to the x (the input of the
%    mapping) at point X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose    computes the jacobian of the model.
%   The procedure for computing the jacobian depends on the underlying representation 
%   of the model. The result <code>out</code> is an array of size number of outputs * number of inputs
%	containing the derivatives of the outputs with respect to the inputs.
%
%   @synopsis   jacob_inputs(m,x)
%   @description computes for each output the jacobian of
%  the model with respect to the x (the input of the
%  mapping) at point <CODE>x</CODE>.
%
%   @synopsis   jacob_inputs(m,x,j)
%   @description computes for output J the jacobian of
%  the model with respect to the x (the input of the
%  mapping) at point <CODE>x</CODE>.
%
%MAN_PAGE_END

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 10/12/1997
%
%	All rights reserved

error(checkargs([{m} varargin],[2 3],'mapping','numeric','numeric'));

check(m);
if nargin == 2,
	out = zeros(get(m,'n_out'),get(m,'n_in'));
else
	out = zeros(length(varargin{2}),get(m,'n_in'));
end
