function out = membership(m,x)
%MEMBERSHIP returns the membership of a rule
%    
%    OUT=MEMBERSHIP(M,X,J)  returns the membership of the
%    rules for the model M.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose returns the membership of a rule.  
%
%   @synopsis   out=membership(m,x,j) 
%   @description returns the membership of the rules for the model <CODE>m</CODE>.
%
%MAN_PAGE_END   

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 13/09/98 12:02
%
%	All rights reserved

d1=size(x,1);
d2=m.n_rules;	% The number of rules

out=zeros(d1,d2);

for i=1:d2,
	xMinusC=x'-m.centers(:,i*ones(1,d1));
	
	switch m.model_code{1},
		case 'productspace',
			if strcmpi(m.model_code{2},'gaussian')|strcmpi(m.model_code{2},'ungaussian'),
				out(:,i) = exp(-sum(xMinusC.*(m.ivariances(:,:,i)*xMinusC),1))';
			elseif strcmpi(m.model_code{2},'inversedist')|strcmpi(m.model_code{2},'uninversedist'),
				out(:,i) = (1e-100+sum(xMinusC.*(m.ivariances(:,:,i)*xMinusC),1)).^(-1/(m.m-1))';
			end
		case 'projected',
			out(:,i) = dofprod(m.rls, m.mfs, x)';
		otherwise,
	end
	
end
