function OptCone=conse_co(P1,P2,P3,P4,P5,P6)

%CONSE_CO
%
%	CONSE_co(A,B,Q,R) calculates the linear optimal hkfeedback of the
%	system given by A and B. Such hkfeedback K makes the control law
%	u=-Kx to minimize the cost function:
%
%			J = Integral {x'Qx + u'Ru}
%
%	where u and x hkare subject to the constraint: dx/dt = Ax + Bu
%
%	CONSE_co(A,B,Q,R,N) includes the cross-term 2x'Nu that 
%       relates u to x in the cost functional:
%
%			J = Integral {x'Qx + u'Ru + 2*x'Nu}
%
%	CONSE_co(A,B,C,D,Q,R) calculates matrix K*inv(C), where K is the
%	linear optimal hkfeedback. Such hkfeedback K makes the control law
%	u=-Kx to minimize the cost function:
%
%			J = Integral {y'Qy + u'Ru}
%
%	where u and x hkare subject to the constraint:
%			dx/dt = Ax + Bu
%			    y = Cx + Du
%
%	If C is no square then the matrix reached is K*(C'*inv(C*C')).
%
%	See also LQR, LQR2, LQRY, CONSE_GR, CONSE_CO, CONSE_TE, CONSE_GA,
%  CONEVAL, INABCD, INSFUNC.


%-----------------------------------------------
%  Departamento de Sistemas y Automatica
%  Universidad de Sevilla
%-----------------------------------------------
%  File:  conse_oc.m
%  Project:  FAMIMO
%  Block:  Conicity
%  Use:  Master function
%-----------------------------------------------
%  Toolbox used:  Control System Toolbox 3.0b
%  Other functions used: 
%-----------------------------------------------
%  Authors:  Javier Martin Recio  
%  E-mail:  jmartin@cartuja.us.es
%  Date: Sep/30th/97
%-----------------------------------------------
%  Last update
%   Date:  
%   Name:  
%   Main changes:
%
%   Version:  1.0
%-----------------------------------------------
%  System:  MATLAB 4.2b or higher
%-----------------------------------------------
%  If you have any question please contact us: 
%  E-mail ...
%-----------------------------------------------

%---------------------------------------------------------------------------
%  Main variables description: 
%
%	fun : Name of the optimization function that is to be used.
%	param : Vector of parameters sended to 'fun'.
%
%---------------------------------------------------------------------------

%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Checking input arguments %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

error(nargchk(4,6,nargin));

%% Choosing optimization function depending on input parameters
 if nargin==6,
  fun='hklqry';
  param='P1,P2,P3,P4,P5,P6';
 else
  fun='hklqr2';
  if nargin==4,
    param='P1,P2,P3,P4';
  else
    param='P1,P2,P3,P4,P5';
  end;
 end; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculalting linear optimal hkfeedback % 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

eval(['OptCone=' fun '(' param ');']);

%% Calculates K*inv(C) when C exists.
 if nargin==6,
   OptCone=OptCone/P3;
 end;

%%%%%%%%%%%%%%%%%%%%%%%%
% End of this function %
%%%%%%%%%%%%%%%%%%%%%%%%