function [mimo]=ms2mm(FM,numRules)

% MS2MM
% Convert n MISO systems into one MIMO system with n outputs.
% [mimo]=ms2mm(FM,numRules)
%         mimo = [A1 B1 C1;A2 B2 C2;...]
%         FM = Array of structures that define a hkfuzzy model MIMO with n hkfuzzy model MISO
%         numRules=Number of Rules
%
% See also fm2mat

%-----------------------------------------------------
% Departamento de Ingenieria de Sistemas y Automatica.
% Universidad de Sevilla 
%-----------------------------------------------------
% File: ms2mm
% Project: FAMIMO
% Block:
% Use: 
%-----------------------------------------------------
% toolbox used: hkfuzzy
%
%-----------------------------------------------------
% Authors: Carolina Cuenca
% E-mail : ccp@cartuja.us.es
% Date: Sep 1998 
%-----------------------------------------------------
% Last update
% Date: 
% name: 
% Main changes : 
% Version Beta 0.0
%-----------------------------------------------------
% System : matlab 5 or higher
%     
%-----------------------------------------------------
% If you have any question please contact us :
% ccp@cartuja.us.es 
%-----------------------------------------------------
%-----------------------------------------------
%  Main variables description:
%    dim = Number of colums of FM: Number of MISO systems
%-----------------------------------------------

dim=size(FM,2);
k=1;
for i=1:numRules
   for j=1:dim
   mimo(k,:)=FM(j).th(i,:);
   k=k+1;
   end
end
