function update_matrices_hook;

params = get(gcf,'UserData');

ni = get(params.m,'n_in');
no = get(params.m,'n_out');

if isempty(ni), ni = 0; end
if isempty(no), no = 0; end

if (ni * no > 0),

	% Do we need to convert params to cell ?
	if ~iscell(params.ny),
		nNy = str2num(params.ny);
		nNu = str2num(params.nu);
		nNd = str2num(params.nd);
			
		oldni = size(nNu,2);
		oldno = size(nNu,1);
		
		params.ny = cell(oldno, oldno);
		params.nu = cell(oldno, oldni);
		params.nd = cell(oldno, oldni);
		
		for i = 1:oldno,
			for j=1:oldno,
				params.ny{i,j} = num2str(nNy(i,j));
			end
		end
		for i = 1:oldno,
			for j=1:oldni,
				params.nu{i,j} = num2str(nNu(i,j));
				params.nd{i,j} = num2str(nNd(i,j));
			end
		end
	end

	ny = params.ny;
	nu = params.nu;
	nd = params.nd;
	
	oldni = size(nu,2);
	oldno = size(nu,1);
	
	if (oldno > 0),
		if (ni > oldni),
			band = cell(oldno, ni - oldni);
			[band{:}] = deal('0');
			nu = [nu band];
			nd = [nd band];
		else
			nu = nu(:,1:ni);
			nd = nd(:,1:ni);
		end
	end
			
	if (no > oldno)
		band = cell(no - oldno, ni);
		[band{:}] = deal('0');
		nu = [nu;band];
		nd = [nd;band];
		
		if (oldno > 0),
			band = cell(oldno, no - oldno);
			[band{:}] = deal('0');
			ny = [ny band];
		end
		band = cell(no - oldno, no);
		[band{:}] = deal('0');
		ny = [ny;band];
	else
		nu = nu(1:no,:);
		nd = nd(1:no,:);
		ny = ny(1:no,1:no);
	end
		
	params.ny = ny;
	params.nu = nu;
	params.nd = nd;
	
	if (ni > 5) | (no > 4)
		% need to convert params.ny, nu and nd to strings
		nNy = zeros(no);
		nNu = zeros(no,ni);
		nNd = zeros(no,ni);
		for i = 1:no,
			for j=1:no,
				nNy(i,j) = str2num(params.ny{i,j});
			end
		end
		for i = 1:no,
			for j=1:ni,
				nNu(i,j) = str2num(params.nu{i,j});
				nNd(i,j) = str2num(params.nd{i,j});
			end
		end
		params.ny = mat2str(nNy);
		params.nu = mat2str(nNu);
		params.nd = mat2str(nNd);
	end	
end

set(gcf,'UserData',params);
