function d=dataset(varargin)
%DATASET Creator of the dataset class
%    
%    DATASET(DATA,SYMBOLS,VARTYPES,LABELS,VARIABLES) create a
%    data object. DATA are the data (each piece of data is on
%    a different line). LABELS is a column vector of the
%    labels (optional) corresponding to each piece of data.
%    VARIABLES [cell],  are the names of the columns of the
%    data. SYMBOLS [cell] are the symbolic correspondance for
%    the symbolic data. VARTYPES is a cell array containing
%    the type of the variable for each column
%    ('continuous','discrete','symbolic','class'). There can
%    only be one 'class' variable at a time. If vartypes is
%    not specified, the types are deduced from the DATA and
%    the symbol field 
%    
%    DATA(DATAFILE,VARIABLES,SYMBOLS,VARTYPES,LABELS) create a
%    data object from a mat datafile. DATAFILE is the name of
%    the mat file where the data are saved. The file must
%    contain a series of variables referenced by
%    VARIABLES[cell]. Each of this variable must be a column
%    vector([double] or [cell]) of length equal to the number
%    of data points.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Creator of the dataset class
%
%   @synopsis	dataset(data,symbols,vartypes,labels,variables)
%   @description  create a data object. <code>data</code> are the data
%	(each piece of data is on a different line). <code>labels</code> is
%	a column vector of the labels (optional) corresponding to each piece of data.
%	<code>variables</code> [cell],	are the names of the columns of the data.
%	<code>symbols</code> [cell] are the symbolic correspondance for the symbolic data.
%	<CODE>vartypes</CODE> is a cell array containing the type of the variable for each
%	column ('continuous','discrete','symbolic','class'). There can only be one 'class'
%	variable at a time. If vartypes is not specified, the types are deduced from the
%	<CODE>data</CODE> and the symbol field 
%
%   @synopsis	data(datafile,variables,symbols,vartypes,labels)
%   @description  create a data object from a mat datafile. <code>datafile</code> is the
%	name of the mat file where the data are saved. The file must contain a series of
%	variables referenced by <CODE>variables</CODE>[cell]. Each of this variable must be a
%	column vector([double] or [cell]) of length equal to the number of data points.
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/03/99

d = dataset({},varargin{:});
