function r = any2str(a);
if ischar(a),
	r = '[';
	for i=1:size(a,1),
		r = [r '''' a(i,:) ''';'];
	end
	if size(a,1) > 0,
		r = r(1:end-1);
	end
	r = [r ']'];
elseif iscell(a),
	r = '{';
	for i =1:size(a,1),
		for j = 1:size(a,2),
			r = [r any2str(a{i,j}) ','];
		end
		if size(a,2) > 0,
			r = r(1:end-1);
		end
		r = [r ';'];
	end
	if size(a,1) > 0,
		r = r(1:end-1);
	end
	r = [r '}'];
elseif isstruct(a)
	r = 'struct(';
	fn = fieldnames(a);
	for i =1:size(fn,1),
		r = [r '''' fn{i} ''',' any2str(getfield(a,fn{i})) ','];
	end
	if size(fn,1) > 0,
		r = r(1:end-1);
	end
	r = [r ')'];
else
	r = mat2str(a);
end

			
