function [RPotSetsHierarchy,RPotSetsMetric,RPotSets]=gkmerge(PotNodes,PotNodesMetric,PotNodesPartition,...
	PotSetsHierarchy,PotSetsMetric,PotSets,i,j,IDs,m,data);
	
RPotSetsHierarchy=PotSetsHierarchy;
RPotSetsMetric=PotSetsMetric;
RPotSets=PotSets;

dimension=size(PotNodes,1);
Current=size(PotSets,2);
A1=IDs(i);
A2=IDs(j);

if A1>0,
	C1=PotNodes(:,A1);
	M1=PotNodesMetric(:,:,A1);
else
	C1=PotSets(:,-A1);
	M1=PotSetsMetric(:,:,-A1);
end

if A2>0,
	C2=PotNodes(:,A2);
	M2=PotNodesMetric(:,:,A2);
else
	C2=PotSets(:,-A2);
	M2=PotSetsMetric(:,:,-A2);
end

RPotSetsHierarchy=[-(Current+1) A1 A2;PotSetsHierarchy];

ToMerge=zeros(size(PotNodes,2),1);

ToMerge=recexp(RPotSetsHierarchy,ToMerge,-(Current+1));

U=ToMerge'*PotNodesPartition;

UHarder=U.^m;
Sums=sum(UHarder');

RPotSets(:,Current+1)=(data*UHarder')/Sums;

Delta=data-RPotSets(:,Current+1)*ones(1,size(data,2));
RPotSetsMetric(:,:,Current+1) = (((ones(dimension,1)*UHarder).*Delta)*Delta')/Sums;
