function l = columnlist(s,p,varargin)
%COLUMNLIST draw a listbox with text in columns
%    
%     use text inside s to format the listbox l.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	draw a listbox with text in columns.
%
%   @synopsys	function l = columnlist(s,p)
%   @description  use text inside s to format the listbox l.
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 4/09/99

for i=1:size(s,2)-1,
	ss = [ones(size(s,1),1)*[32] strvcat(s{:,i}) ones(size(s,1),1)*[32 33]];
	s(:,i) = cellstr(ss)';
end

ss = [ones(size(s,1),1)*[32] strvcat(s{:,end})];
s(:,end) = cellstr(ss)';

for j=1:size(s,1),
	ns{j} = [s{j,:}];
end

s = uicontrol('style','text','Units','normal','string',[32 ns{1}],'position',[p(1:3)+[0 p(4) 0] 0.05],'HorizontalAlignment','Left','fontname','monaco');
l = uicontrol('style','listbox','Units','normal','backgroundcolor',[1 1 1],'string',ns(2:end),'Position',p,'fontname','monaco',varargin{:});
