function refreshsysfigcb
%REFRESHSYSFIGCB The main function for dealing with
%    multiple plots
%    
%    REFRESHSYSFIGCB 
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	The main function for dealing with multiple plots
%
%   @synopsis	refreshsysfigcb
%   @description  
%
%   @see 
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 7/06/99

% Collect environment information

f = gcf;

ud = get(f,'userdata');

m = ud.m;

sel = get(ud.f1,'value');
n = length(sel);

if n == 0, return; end

% Do the layout

switch n,
case 1,
	xp = [0.26];
	yp = [0.04];
	hp = [0.95];
	wp = [0.7];
case 2,
	xp = [0.26 0.26];
	yp = [0.54 0.04];
	hp = [0.45 0.46];
	wp = [0.7 0.7];
case 3,
	xp = [0.26 0.26 0.26];
	yp = [0.7 0.37 0.04];
	hp = [0.29 0.29 0.29];
	wp = [0.7 0.7 0.7];
case 4,
	xp = [0.26 0.26	0.63 0.63];
	yp = [0.54 0.04 0.54 0.04];
	hp = [0.45 0.46 0.45 0.46];
	wp = [0.32 0.32 0.32 0.32];
case 5,
	xp = [0.26 0.26	0.63 0.63 0.63];
	yp = [0.54 0.04 0.7 0.37 0.04];
	hp = [0.45 0.46 0.29 0.29 0.29];
	wp = [0.32 0.32 0.32 0.32 0.32];
case 6,
	xp = [0.26 0.26	0.26 0.63 0.63 0.63];
	yp = [0.7 0.37 0.04 0.7 0.37 0.04];
	hp = [0.29 0.29 0.29 0.29 0.29 0.29];
	wp = [0.32 0.32 0.32 0.32 0.32 0.32];
otherwise,
	xp = [0.26 0.26	0.26 0.63 0.63 0.63];
	yp = [0.7 0.37 0.04 0.7 0.37 0.04];
	hp = [0.29 0.29 0.29 0.29 0.29 0.29];
	wp = [0.32 0.32 0.32 0.32 0.32 0.32];
sel = sel(1:6);
n = 6;
end

% Build the axes and plot the functions
if ~isfield(ud,'axes')|length(ud.axes) ~= n,
	if isfield(ud,'axes'),
		for i=1:length(ud.axes),
			delete(ud.axes(i));
		end
	end
	ud.axes = [];
	for i = 1:n,
		ud.axes(i) = axes('Position', [xp(i) yp(i) wp(i) hp(i)],'ButtonDownFcn','temp = get(gca,''color'');set(gca,''color'',[0 0 0]);drawnow;set(gca,''color'',temp)')
	end
else
	for i=1:length(ud.axes),
		axes(ud.axes(i));
		cla;
	end
end
set(f,'userdata',ud);

maps = get(m,'mapping');

axes(ud.axes(1));
drawcontrols(maps{sel(1)},f,ud.axes(1),[0.01 0.01 0.2 0.53]);

for i = 1:n,
	axes(ud.axes(i));
	
	[in,out] = regress(m,m.opt.links_history(sel(i),1));
	
	plot(maps{sel(i)},'data',[in{1} out{1}])
	
	udbis = get(ud.axes(i), 'userdata');
	udbis.nmap = sel(i);
	set(ud.axes(i),'userdata',udbis);
end

