function errordb(m)
%ERRORDB Graphical User Interface for inspecting the
%    errors of the mappings
%    
%     
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Graphical User Interface for inspecting the errors of the mappings
%
%   @synopsys	errordb(m)
%   @description  
%
%   @see 
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 5/09/99

ud = get(gcf,'userdata')

opt=get(ud.m,'opt');
if isfield(opt,'errors_database')  & ~isempty(opt.errors_database.system_output),
  database=opt.errors_database;
else
	error(['No error database has been defined for this system. Please use error first.']);
end

ns = get(ud.l,'string');

switch get(ud.pop2,'value'),
	case 1,	%Output
		[s, idxs] = sort([database.system_output{ud.switch}]);
	case 2,
		[s, idxs] = sortrows(char(database.mapping_name(ud.switch)));
	case 3,
		[s, idxs] = sortrows(char(database.file(ud.switch)));
	case 4,
		[s, idxs] = sortrows(char(database.error_type(ud.switch)));
	case 5,
		[s, idxs] = sort([database.value{ud.switch}]);
end

ns = ns(idxs,:);
ud.switch = ud.switch(idxs);

switch get(ud.pop1,'value'),
	case 1,	%Output
		[s, idxs] = sort([database.system_output{ud.switch}]);
	case 2,
		[s, idxs] = sortrows(char(database.mapping_name(ud.switch)));
	case 3,
		[s, idxs] = sortrows(char(database.file(ud.switch)));
	case 4,
		[s, idxs] = sortrows(char(database.error_type(ud.switch)));
	case 5,
		[s, idxs] = sort([database.value{ud.switch}]);
end


set(ud.l,'string',ns(idxs,:));
ud.switch = ud.switch(idxs);

set(gcf,'userdata',ud)
